define(['angular', 'app'], function (angular, app) {
    "use strict";
    app.service('modalService', function ($modal, $q) {

        var modalDefaults = {
            backdrop: "static",
            keyboard: true,
            modalFade: true,
            templateUrl: 'src/ui-components/modals/helper/modal_template.html',
            windowTemplateUrl: 'src/ui-components/modals/helper/modal-window_template.html'
        };

        var modalContent = {
            closeButtonText: null,
            actionButtonText: null,
            resetButtonText: null,
            headerText: null,
            subHeaderText: null,
            bodyText: null,
            bodyContentUrl: null,
            data: null,
            metaData: null,
            type: null,
            useEditForm: false,
            icon: null,
            centerBody:false
        };

        this.showModal = function (customModalDefaults, customModalOptions, otherOptions) {
            if (!customModalDefaults) {
                customModalDefaults = {};
            }

            return this.show(customModalDefaults, customModalOptions, otherOptions);
        };

        this.show = function (customModalDefaults, customModalOptions, otherOptions) {
            var tempModalDefaults = {};
            var tempModalOptions = {};

            angular.extend(tempModalDefaults, modalDefaults, customModalDefaults);
            angular.extend(tempModalOptions, modalContent, customModalOptions);

            if (!tempModalDefaults.controller) {
                tempModalDefaults.controller = function ($scope, $modalInstance, focusService) {

                    $scope.$watch(function () {
                        return $('div.modal-header h3').is(":visible");
                    }, function (isVisible, wasVisible) {
                        if (isVisible && !wasVisible) {
                            focusService.focusElement($('div.modal-header h3'));
                        }
                    });

                    // otherOptions currently only includes a layout flag for the modal buttons
                    // current default is to have the 'cancel' button first, and then the 'okay' button
                    if (otherOptions) {
                        $scope.okButtonFirst = otherOptions.okButtonFirst;
                    }

                    $scope.modalContent = tempModalOptions;
                    $scope.modalContent.ok = function (result) {
                        allowModalToClose().then(function () {
                            $modalInstance.close(result);
                            if (tempModalOptions.additionalAction) {
                                tempModalOptions.additionalAction();
                            }
                        });
                    };
                    $scope.modalContent.close = function () {
                        $modalInstance.dismiss('cancel');
                    };

                    $scope.originalData = angular.copy($scope.modalContent.data);
                    $scope.modalContent.reset = function () {
                        for (var prop in $scope.modalContent.data) {
                            if (angular.isDefined($scope.originalData[prop])) {
                                $scope.modalContent.data[prop] = angular.isDefined($scope.originalData[prop]) ? angular.copy($scope.originalData[prop]) : null;
                            }
                        }
                    };

                    function allowModalToClose() {
                        var defer = $q.defer();
                        if ($scope.modalContent.useEditForm
                            && angular.element('.modal-content validation-summary')
                            && angular.element('.modal-content validation-summary').controller('form')) {
                            angular.element('.modal-content validation-summary').controller('form').validationSummary.validate().then( function () {
                                defer.resolve();
                            }, function () {
                                defer.reject();
                            });
                        } else {
                            defer.resolve();
                        }
                        return defer.promise;
                    }
                }
            }

            return $modal.open(tempModalDefaults).result;
        };
    });
});